import pandas as pd
import numpy as np
import os

averages = None
results_folder = "../evaluations"

for (root, dirs, files) in os.walk(results_folder):
    stream = os.path.basename(root)
    if stream == "evaluations":
        continue

    for file in files:
        classifier = file[:-4]

        print("Averaging {0} results on {1} stream".format(classifier, stream))
        df = pd.read_csv(os.path.join(root, file), na_values=["?", "-Infinity"])
        df_mean = df.mean().copy()
        df_mean["Classifier"] = classifier
        df_mean["Dataset"] = stream
        df_mean = df_mean.to_frame().transpose()

        if averages is None:
            averages = df_mean
        else:
            averages = averages.append(df_mean, ignore_index=True)

averages = averages.loc[:, ["Dataset", "Classifier", "Accuracy", "AUC", "sAUC", "G-Mean", "Kappa", "KappaM", "Recall",
                            "Periodical holdout AUC", "evaluation time (cpu seconds)", "learning evaluation instances",
                            "model cost (RAM-Hours)", "model serialized size (bytes)"]]

averages.to_csv(os.path.join(results_folder, "Averages.csv"), index=False)
print("\nDone!")
